//
//  MCSService.h
//  BPClientTest
//
//  Created by Michael Clark on 10-02-28.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MCSServiceTracker.h"

extern NSString*  kMCSServiceErrorDomain;

typedef enum {
    kMCSServiceServerNotFoundError = 100,
    kMCSServiceServerDisconnectedError = 200
} MCSServiceErrorCode;



#pragma mark -
#pragma mark Abstract Service
@interface MCSService : NSObject {
    NSString*   name;
    
    NSString*   serviceAddress;
    NSUInteger  servicePort;
    
    MCSServiceResolveScope scope;
    
    NSDictionary* settings;
}
@property (nonatomic,readonly,retain) NSString*  name;
@property (nonatomic,readonly,retain) NSString*  serviceAddress;
@property (nonatomic,readonly,assign) NSUInteger servicePort;
@property (nonatomic,readonly,assign) MCSServiceResolveScope scope;
@property (nonatomic,readonly,retain) NSDictionary* settings;


- (id)initWithName: (NSString*)aName scope: (MCSServiceResolveScope)aScope serviceAddress: (NSString*)anAddress servicePort: (NSUInteger)aPort settings: (NSDictionary*)aSettings;

@end



#import <MCClientServer/MCAccessClient.h>

#pragma mark -
#pragma mark Accessd Service
@interface MCSAccessdService : MCSService {
    MCAccessClient*     accessClient;
    BOOL  working;
    
    NSArray*    databases;
    
    id          delegate; // weak
    
	NSString*   clientUUID;
    NSString*   username;
    NSString*   password;
    NSString*   databaseName;
	NSString*   cloudUsername;
	NSString*   serverPrettyName;
	NSData*     serverImageData;
    NSUInteger  schemaNumber;
	
	BOOL waitingForAuth;
	BOOL waitingForDatabases;
	BOOL waitingForInfo;
}

@property (nonatomic,readwrite,assign) id delegate;

@property (nonatomic,readonly,retain) NSArray* databases;
@property (nonatomic,readonly,retain) NSString *clientUUID;
@property (nonatomic,readonly,retain) NSString *username;
@property (nonatomic,readonly,retain) NSString *password;
@property (nonatomic,readonly,retain) NSString *databaseName;
@property (nonatomic,readonly,assign) NSUInteger schemaNumber;
@property (nonatomic,readonly,retain) NSString *cloudUsername;
@property (nonatomic,readonly,retain) NSString *serverPrettyName;
@property (nonatomic,readonly,retain) NSData *serverImageData;

- (void)stop;

- (void)fetchDatabaseList;
- (void)getCompanyIDFromServer;
- (void)authenticateClientWithUUID:(NSString *)uuid username: (NSString*)aUsername password: (NSString*)aPassword forDatabaseNamed: (NSString*)aName withSchemaVersion: (NSUInteger)aSchemaVersion  cloudAccount:(NSString *)cloudAccount;
- (void)authenticateUsername: (NSString*)aUsername password: (NSString*)aPassword forDatabaseNamed: (NSString*)aName withSchemaVersion: (NSUInteger)aSchemaVersion;

@end

@interface NSObject (MCSAccessdServiceDelegate)

- (void)accessdServiceRetrievedDatabases: (MCSAccessdService*)service;
- (void)accessdService: (MCSAccessdService*)service failedDatabaseRetrievalWithError: (NSError*)error;

- (void)accessdService: (MCSAccessdService*)service credentialCheckSucceededForUsername: (NSString*)username infoDictionary: (NSDictionary*)dict;
- (void)accessdService: (MCSAccessdService*)service credentialCheckFailedForUsername: (NSString*)username error: (NSError*)error;

- (void)accessdServiceLoadedServerDetails: (MCSAccessdService*)service;

@end

